package cn.modificator.launcher.model;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import cn.modificator.launcher.widgets.EInkLauncherView;


public class AppDataCenter {
  private Context mContext;
  private static List<ResolveInfo> mApps;
  private int pageIndex = 0;
  private int pageCount = 1;
  private int colNum = 5;
  private int rowNum = 5;
  private EInkLauncherView launcherView;
  private TextView pageStatus;
  private Set<String> hideApps = new HashSet<>();

  public AppDataCenter(Context context) {
    this.mContext = context;
    mApps = new ArrayList<>();
  }

  public void setLauncherView(EInkLauncherView launcherView) {
    this.launcherView = launcherView;
    this.launcherView.setOnSingleAppHideChangeListener(new EInkLauncherView.OnSingleAppHideChange() {
      @Override
      public void change(String pkg) {
        refreshAppList();
      }
    });
    launcherView.setHideAppPkg(hideApps);
    setPageShow();
  }

  public void setPageStatus(TextView pageStatus) {
    this.pageStatus = pageStatus;
    String pageCounter = (pageIndex + 1) + "/" + (pageCount + 1);
    pageStatus.setText(pageCounter);
  }

  public void setHideApps(Set<String> hideApps) {
    this.hideApps.clear();
    this.hideApps.addAll(hideApps);
    loadApps();
  }

  public Set<String> getHideApps() {
    return hideApps;
  }

  private void loadApps() {
    Intent mainIntent = new Intent(Intent.ACTION_MAIN, null);
    mainIntent.addCategory(Intent.CATEGORY_LAUNCHER);
    if (launcherView != null) {
      hideApps.clear();
      hideApps.addAll(launcherView.getHideAppPkg());
    }
    mApps.clear();
    for (ResolveInfo resolveInfo : mContext.getPackageManager().queryIntentActivities(mainIntent, 0)) {
      if ("cn.modificator.launcher.Launcher".equals(resolveInfo.activityInfo.name)) continue;
      if (!hideApps.contains(resolveInfo.activityInfo.packageName)) {
        mApps.add(resolveInfo);
      }
    }
    updatePageCount();
  }

  private void loadAllApps() {
    Intent mainIntent = new Intent(Intent.ACTION_MAIN, null);
    mainIntent.addCategory(Intent.CATEGORY_LAUNCHER);
    mApps.clear();
    mApps.addAll(mContext.getPackageManager().queryIntentActivities(mainIntent, 0));
    launcherView.setHideAppPkg(hideApps);
    updatePageCount();
  }

  public void showNextPage() {
    if (pageIndex >= pageCount) return;
    pageIndex++;
    setPageShow();
  }

  public void showLastPage() {
    if (pageIndex <= 0) return;
    pageIndex--;
    setPageShow();
  }

  public void setColNum(int colNum) {
    this.colNum = colNum;
    updatePageCount();
    setPageShow();
  }

  public void setRowNum(int rowNum) {
    this.rowNum = rowNum;
    updatePageCount();
    setPageShow();
  }

  public void refreshAppList() {
    refreshAppList(false);
  }

  public void refreshAppList(boolean showAll) {
    if (showAll) loadAllApps();
    else loadApps();
    setPageShow();
  }

  private void setPageShow() {
    int itemCount = colNum * rowNum;
    int pageStart = pageIndex * itemCount;
    int pageEnd = (pageStart + itemCount) > mApps.size() ? mApps.size() : (pageStart + itemCount);
    launcherView.setAppList(mApps.subList(pageStart, pageEnd));
    String pageCounter = (pageIndex + 1) + "/" + (pageCount + 1);
    pageStatus.setText(pageCounter);
  }

  private void updatePageCount() {
    pageCount = mApps.size() / (colNum * rowNum) - (mApps.size() % (colNum * rowNum) == 0 ? 1 : 0);
    pageCount = pageCount < 0 ? 0 : pageCount;
    pageIndex = pageIndex > pageCount ? pageCount : pageIndex;
  }
}
