package cn.modificator.launcher.filemanager;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;

import androidx.documentfile.provider.DocumentFile;

import android.widget.Toast;

import java.io.File;


public class Futils {
  public static void openFile(final File f, final Activity m) {
    DocumentFile documentFile = DocumentFile.fromFile(f);
    try {
      openunknown(documentFile, m, false);
    } catch (Exception e) {
      Toast.makeText(m, "unkown file", Toast.LENGTH_LONG).show();
      openWith(documentFile, m);
    }
  }


  public static void openunknown(DocumentFile f, Context c, boolean forcechooser) {
    Intent intent = new Intent();
    intent.setAction(Intent.ACTION_VIEW);
    intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);

    String type = f.getType();
    if (type != null && type.trim().length() != 0 && !type.equals("*/*")) {
      type = MimeTypeUtil.getMIMEType(f.getName());
    }
    if (type != null && type.trim().length() != 0 && !type.equals("*/*")) {
      intent.setDataAndType(f.getUri(), type);
      Intent startintent;
      if (forcechooser)
        startintent = Intent.createChooser(intent, "mmmm");
      else startintent = intent;
      try {
        c.startActivity(startintent);
      } catch (ActivityNotFoundException e) {
        e.printStackTrace();
        Toast.makeText(c, "no idea: unknown", Toast.LENGTH_SHORT).show();
        openWith(f, c);
      }
    } else {
      openWith(f, c);
    }

  }

  public static void openWith(final DocumentFile f, final Context c) {

    AlertDialog.Builder a = new AlertDialog.Builder(c);
    a.setTitle("Abrir como");
    String[] items = new String[]{"texto", "imagen", "video", "audio", "otro"};

    a.setItems(items, new DialogInterface.OnClickListener() {
      @Override
      public void onClick(DialogInterface dialog, int which) {
        Intent intent = new Intent();
        intent.setAction(android.content.Intent.ACTION_VIEW);
        intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION | Intent.FLAG_ACTIVITY_NEW_TASK);
        switch (which) {
          case 0:
            intent.setDataAndType(f.getUri(), "text/*");
            break;
          case 1:
            intent.setDataAndType(f.getUri(), "image/*");
            break;
          case 2:
            intent.setDataAndType(f.getUri(), "video/*");
            break;
          case 3:
            intent.setDataAndType(f.getUri(), "audio/*");
            break;
          case 4:
            intent.setDataAndType(f.getUri(), "*/*");
            break;
        }
        try {
          c.startActivity(intent);
        } catch (Exception e) {
          Toast.makeText(c, "no hay programas para abrir el documento", Toast.LENGTH_SHORT).show();
          openWith(f, c);
        }
      }
    });
    try {
      a.show();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }


}
