package cn.modificator.launcher;

import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;

import androidx.core.graphics.drawable.DrawableCompat;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import cn.modificator.launcher.filemanager.FileComparator;

public class Utils {

  public static Drawable tintDrawable(Drawable drawable, ColorStateList colors) {
    final Drawable wrappedDrawable = DrawableCompat.wrap(drawable);
    DrawableCompat.setTintList(wrappedDrawable, colors);
    return wrappedDrawable;
  }

  public static List<File> getFileListByDirPath(File path) {
    File[] files = path.listFiles();

    if (files == null) {
      return new ArrayList<>();
    }

    List<File> result = Arrays.asList(files);
    Collections.sort(result, new FileComparator());
    return result;
  }
}
