package cn.modificator.launcher;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import java.io.File;

import cn.modificator.launcher.model.AppDataCenter;
import cn.modificator.launcher.widgets.EInkLauncherView;

public class Launcher extends Activity {

  public static final String ROW_NUM_KEY = "rowNumKey";
  public static final String COL_NUM_KEY = "colNumKey";
  public static final String HIDE_APPS_KEY = "hideAppsKey";
  public static final String DELETEAPP = "deleteApp";
  public static final String LAUNCHER_ACTION = "launcherReceiver";
  public static final String LAUNCHER_FONT_SIZE = "launcherFontSize";

  EInkLauncherView launcherView;
  AppDataCenter dataCenter = null;
  Config config = new Config(this);
  LauncherUpdateReceiver updateReceiver;
  TextView pageStatus;
  File iconFile;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.launcher_activity);
    if (getExternalCacheDir() != null) {
      iconFile = new File(getExternalCacheDir().getParentFile().getParentFile().getParentFile().getParentFile(), "E-Ink Launcher" + File.separator + "icon");
      if (!iconFile.exists()) {
        iconFile.mkdir();
      }
    }
    initView();
  }

  private void initView() {
    launcherView = findViewById(R.id.mList);
    pageStatus = findViewById(R.id.pageStatus);
    (this.<ImageView>findViewById(R.id.toSetting)).setImageDrawable(Utils.tintDrawable(getResources().getDrawable(R.drawable.navibar_icon_settings_highlight), ColorStateList.valueOf(0xff000000)));

    launcherView.setHideAppPkg(config.getHideApps());

    dataCenter = new AppDataCenter(this);
    dataCenter.setHideApps(config.getHideApps());
    dataCenter.setPageStatus(pageStatus);
    dataCenter.setLauncherView(launcherView);
    updateColNum(config.getColNum());
    updateRowNum(config.getRowNum());
    launcherView.setFontSize(config.getFontSize());

    findViewById(R.id.lastPage).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        dataCenter.showLastPage();
      }
    });
    findViewById(R.id.nextPage).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        dataCenter.showNextPage();
      }
    });
    findViewById(R.id.toSetting).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        getFragmentManager().beginTransaction()
            .replace(android.R.id.content, new SettingFramgent())
            .addToBackStack(null)
            .commit();
      }
    });
    findViewById(R.id.deleteFinish).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        launcherView.setDelete(false);
        dataCenter.refreshAppList();
        config.setHideApps(dataCenter.getHideApps());
        v.setVisibility(View.GONE);
      }
    });
    launcherView.setTouchListener(new EInkLauncherView.TouchListener() {
      @Override
      public void toNext() {
        dataCenter.showNextPage();
      }

      @Override
      public void toLast() {
        dataCenter.showLastPage();
      }
    });

    updateReceiver = new LauncherUpdateReceiver();
    IntentFilter filter = new IntentFilter();
    filter.addAction(LAUNCHER_ACTION);
    registerReceiver(updateReceiver, filter);

    IntentFilter appChangeFilter = new IntentFilter();
    appChangeFilter.addAction(Intent.ACTION_PACKAGE_ADDED);
    appChangeFilter.addAction(Intent.ACTION_PACKAGE_REMOVED);
    appChangeFilter.addAction(Intent.ACTION_PACKAGE_REPLACED);
    appChangeFilter.addDataScheme("package");
    registerReceiver(appChangeReceiver, appChangeFilter);

    try {
      launcherView.setSystemApp(!isUserApp(getPackageManager().getPackageInfo(getPackageName(), 0)));
    } catch (PackageManager.NameNotFoundException e) {
      e.printStackTrace();
    }
  }

  private void updateRowNum(int rowNum) {
    dataCenter.setRowNum(rowNum);
    launcherView.setRowNum(rowNum);
    config.setRowNum(rowNum);
  }

  private void updateColNum(int colNum) {
    dataCenter.setColNum(colNum);
    launcherView.setColNum(colNum);
    config.setColNum(colNum);
  }

  @Override
  public boolean onKeyUp(int keyCode, KeyEvent event) {
    if (keyCode == KeyEvent.KEYCODE_PAGE_UP) {
      dataCenter.showLastPage();
    } else if (keyCode == KeyEvent.KEYCODE_PAGE_DOWN) {
      dataCenter.showNextPage();
    } else if (keyCode == KeyEvent.KEYCODE_BACK) {
      return true;
    }
    return super.onKeyUp(keyCode, event);
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();
    unregisterReceiver(updateReceiver);
    unregisterReceiver(appChangeReceiver);
  }

  class LauncherUpdateReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
      Bundle bundle = intent.getExtras();
      if (bundle.containsKey(ROW_NUM_KEY)) {
        updateRowNum(bundle.getInt(ROW_NUM_KEY));
      } else if (bundle.containsKey(COL_NUM_KEY)) {
        updateColNum(bundle.getInt(COL_NUM_KEY));
      } else if (bundle.containsKey(DELETEAPP)) {
        launcherView.setDelete(true);
        dataCenter.refreshAppList(true);
        findViewById(R.id.deleteFinish).setVisibility(View.VISIBLE);
      } else if (bundle.containsKey(LAUNCHER_FONT_SIZE)) {
        launcherView.setFontSize(bundle.getFloat(LAUNCHER_FONT_SIZE));
      }
    }
  }

  BroadcastReceiver appChangeReceiver = new BroadcastReceiver() {
    @Override
    public void onReceive(Context context, Intent intent) {
      dataCenter.refreshAppList(launcherView.isDelete());
    }
  };

  @Override
  public void onBackPressed() {
    if (getFragmentManager().getBackStackEntryCount() > 0) {
      super.onBackPressed();
      config.saveFontSize();
    }
  }

  @Override
  public boolean onKeyDown(int keyCode, KeyEvent event) {
    if (keyCode == KeyEvent.KEYCODE_BACK && getFragmentManager().getBackStackEntryCount() == 0) {
      return true;
    }
    return super.onKeyDown(keyCode, event);
  }

  public boolean isSystemApp(PackageInfo pInfo) {
    return ((pInfo.applicationInfo.flags & ApplicationInfo.FLAG_SYSTEM) != 0);
  }

  public boolean isSystemUpdateApp(PackageInfo pInfo) {
    return ((pInfo.applicationInfo.flags & ApplicationInfo.FLAG_UPDATED_SYSTEM_APP) != 0);
  }

  public boolean isUserApp(PackageInfo pInfo) {
    return (!isSystemApp(pInfo) && !isSystemUpdateApp(pInfo));
  }
}
